<?php
/**
 * Cron Job Setup Script
 * This script helps you set up the daily rebate payout cron job
 */

echo "<h2>Daily Rebate Payout Cron Job Setup</h2>";

// Get current script directory
$scriptDir = __DIR__;
$cronFile = $scriptDir . "/daily_rebate_payout_cron.php";

echo "<h3>1. Cron Job Configuration</h3>";
echo "<p><strong>Schedule:</strong> Every day at 12:01 AM</p>";
echo "<p><strong>Cron Expression:</strong> <code>1 0 * * *</code></p>";
echo "<p><strong>Script Path:</strong> <code>$cronFile</code></p>";

echo "<h3>2. Cron Job Command</h3>";
echo "<div style='background: #f0f0f0; padding: 10px; border-radius: 5px; font-family: monospace;'>";
echo "1 0 * * * php $cronFile >> {$scriptDir}/cron_logs/cron_output.log 2>&1";
echo "</div>";

echo "<h3>3. Alternative Commands (depending on your server)</h3>";
echo "<div style='background: #f0f0f0; padding: 10px; border-radius: 5px; font-family: monospace;'>";
echo "# If PHP is not in PATH, use full path:<br>";
echo "1 0 * * * /usr/bin/php $cronFile >> {$scriptDir}/cron_logs/cron_output.log 2>&1<br><br>";
echo "# For cPanel/shared hosting:<br>";
echo "1 0 * * * /usr/local/bin/php $cronFile >> {$scriptDir}/cron_logs/cron_output.log 2>&1<br><br>";
echo "# For Windows (if using Windows Task Scheduler):<br>";
echo "php.exe \"$cronFile\" >> \"{$scriptDir}\\cron_logs\\cron_output.log\" 2>&1";
echo "</div>";

echo "<h3>4. How to Add Cron Job</h3>";
echo "<h4>Linux/Unix servers:</h4>";
echo "<ol>";
echo "<li>Open terminal and run: <code>crontab -e</code></li>";
echo "<li>Add the cron job line from above</li>";
echo "<li>Save and exit</li>";
echo "<li>Verify with: <code>crontab -l</code></li>";
echo "</ol>";

echo "<h4>cPanel/Shared Hosting:</h4>";
echo "<ol>";
echo "<li>Login to cPanel</li>";
echo "<li>Go to 'Cron Jobs' section</li>";
echo "<li>Add new cron job with:</li>";
echo "<ul>";
echo "<li><strong>Minute:</strong> 1</li>";
echo "<li><strong>Hour:</strong> 0</li>";
echo "<li><strong>Day:</strong> *</li>";
echo "<li><strong>Month:</strong> *</li>";
echo "<li><strong>Weekday:</strong> *</li>";
echo "<li><strong>Command:</strong> php $cronFile</li>";
echo "</ul>";
echo "</ol>";

echo "<h3>5. Test the Cron Job</h3>";
echo "<p>You can test the cron job manually by running:</p>";
echo "<div style='background: #f0f0f0; padding: 10px; border-radius: 5px; font-family: monospace;'>";
echo "php $cronFile";
echo "</div>";

// Create logs directory
$logsDir = $scriptDir . "/cron_logs";
if (!is_dir($logsDir)) {
    if (mkdir($logsDir, 0755, true)) {
        echo "<p style='color: green;'>✓ Created logs directory: $logsDir</p>";
    } else {
        echo "<p style='color: red;'>✗ Failed to create logs directory: $logsDir</p>";
    }
} else {
    echo "<p style='color: green;'>✓ Logs directory already exists: $logsDir</p>";
}

// Check if cron file exists
if (file_exists($cronFile)) {
    echo "<p style='color: green;'>✓ Cron script exists: $cronFile</p>";
} else {
    echo "<p style='color: red;'>✗ Cron script not found: $cronFile</p>";
}

echo "<h3>6. Monitoring</h3>";
echo "<p>The cron job will create log files in: <code>$logsDir</code></p>";
echo "<ul>";
echo "<li><strong>daily_rebate_payout.log</strong> - Detailed execution log</li>";
echo "<li><strong>cron_output.log</strong> - System output and errors</li>";
echo "</ul>";

echo "<h3>7. What the Cron Job Does</h3>";
echo "<ol>";
echo "<li>Runs every day at 12:01 AM</li>";
echo "<li>Finds all users who have rebates from the previous day</li>";
echo "<li>Adds their total rebate amount to their wallet balance (motta column)</li>";
echo "<li>Marks rebates as paid to prevent double processing</li>";
echo "<li>Logs all activities for monitoring</li>";
echo "<li>Uses database transactions for data integrity</li>";
echo "</ol>";

echo "<h3>8. Important Notes</h3>";
echo "<ul>";
echo "<li><strong>Time Zone:</strong> The cron uses Asia/Kolkata timezone</li>";
echo "<li><strong>Safety:</strong> Uses file locking to prevent multiple executions</li>";
echo "<li><strong>Logging:</strong> All activities are logged for debugging</li>";
echo "<li><strong>Transactions:</strong> Uses database transactions for reliability</li>";
echo "<li><strong>VIP Based:</strong> Only processes rebates for VIP users (Level 1+)</li>";
echo "</ul>";

echo "<h3>9. Troubleshooting</h3>";
echo "<ul>";
echo "<li>Check the log files for errors</li>";
echo "<li>Ensure PHP has write permissions to the logs directory</li>";
echo "<li>Verify database connection settings</li>";
echo "<li>Test the script manually before setting up the cron</li>";
echo "</ul>";

echo "<p><strong>Setup Complete!</strong> Your daily rebate payout cron job is ready to be configured.</p>";
?>
